#cs ----------------------------------------------------------------------------

 AutoIt Version: 3.3.0.0
 Author:         myName

 Script Function:
	Template AutoIt script.

#ce ----------------------------------------------------------------------------
#include-once

; Script Start - Add your code below here

#cs
Global $VK_TAB          =  0x09
Global $VK_CLEAR        =  0x0C
Global $VK_RETURN       =  0x0D
Global $VK_SHIFT        =  0x10
Global $VK_CONTROL      =  0x11
Global $VK_ESCAPE       =  0x1B
Global $VK_SPACE        =  0x20
Global $VK_LEFT         =  0x25
Global $VK_UP           =  0x26
Global $VK_RIGHT        =  0x27
Global $VK_DOWN         =  0x28
Global $VK_DELETE       =  0x2E
Global $VK_0 			=  0x30
Global $VK_1 			=  0x31
Global $VK_2 			=  0x32
Global $VK_3 			=  0x33
Global $VK_4 			=  0x34
Global $VK_5 			=  0x35
Global $VK_6 			=  0x36
Global $VK_7 			=  0x37
Global $VK_8 			=  0x38
Global $VK_9 			=  0x39
Global $VK_A 			=  0x41
Global $VK_B 			=  0x42
Global $VK_C 			=  0x43
Global $VK_D 			=  0x44
Global $VK_E 			=  0x45
Global $VK_F 			=  0x46
Global $VK_G 			=  0x47
Global $VK_H 			=  0x48
Global $VK_I 			=  0x49
Global $VK_J 			=  0x4A
Global $VK_K 			=  0x4B
Global $VK_L 			=  0x4C
Global $VK_M 			=  0x4D
Global $VK_N 			=  0x4E
Global $VK_O 			=  0x4F
Global $VK_P 			=  0x50
Global $VK_Q 			=  0x51
Global $VK_R 			=  0x52
Global $VK_S 			=  0x53
Global $VK_T 			=  0x54
Global $VK_U 			=  0x55
Global $VK_V 			=  0x56
Global $VK_W 			=  0x57
Global $VK_X 			=  0x58
Global $VK_Y 			=  0x59
Global $VK_Z 			=  0x5A
Global $VK_NUMPAD0      =  0x60
Global $VK_NUMPAD1      =  0x61
Global $VK_NUMPAD2      =  0x62
Global $VK_NUMPAD3      =  0x63
Global $VK_NUMPAD4      =  0x64
Global $VK_NUMPAD5      =  0x65
Global $VK_NUMPAD6      =  0x66
Global $VK_NUMPAD7      =  0x67
Global $VK_NUMPAD8      =  0x68
Global $VK_NUMPAD9      =  0x69
Global $VK_MULTIPLY     =  0x6A
Global $VK_ADD          =  0x6B
Global $VK_SEPARATOR    =  0x6C
Global $VK_SUBTRACT     =  0x6D
Global $VK_DECIMAL      =  0x6E
Global $VK_DIVIDE       =  0x6F
Global $VK_F1           =  0x70
Global $VK_F2           =  0x71
Global $VK_F3           =  0x72
Global $VK_F4           =  0x73
Global $VK_F5           =  0x74
Global $VK_F6           =  0x75
Global $VK_F7           =  0x76
Global $VK_F8           =  0x77
Global $VK_F9           =  0x78
Global $VK_F10          =  0x79
Global $VK_F11          =  0x7A
Global $VK_F12          =  0x7B
Global $VK_F13          =  0x7C
Global $VK_F14          =  0x7D
Global $VK_F15          =  0x7E
Global $VK_F16          =  0x7F
Global $VK_F17          =  0x80
Global $VK_F18          =  0x81
Global $VK_F19          =  0x82
Global $VK_F20          =  0x83
Global $VK_F21          =  0x84
Global $VK_F22          =  0x85
Global $VK_F23          =  0x86
Global $VK_F24          =  0x87
Global $VK_NUMLOCK      =  0x90
Global $VK_SCROLL       =  0x91

Global $VK_OEM_NEC_EQUAL = 0x92   ;// '=' key on numpad

Global $VK_OEM_1         = 0xBA   ;// ';:' for US
Global $VK_OEM_PLUS      = 0xBB   ;// '+' any country
Global $VK_OEM_COMMA     = 0xBC   ;// ',' any country
Global $VK_OEM_MINUS     = 0xBD   ;// '-' any country
Global $VK_OEM_PERIOD    = 0xBE   ;// '.' any country
Global $VK_OEM_2         = 0xBF   ;// '/?' for US
Global $VK_OEM_3         = 0xC0   ;// '`~' for US

Global $VK_OEM_4         = 0xDB  ;//  '[{' for US
Global $VK_OEM_5         = 0xDC  ;//  '\|' for US
Global $VK_OEM_6         = 0xDD  ;//  ']}' for US
Global $VK_OEM_7         = 0xDE  ;//  ''"' for US
Global $VK_OEM_8         = 0xDF

Global $VK_OEM_102       = 0xE2  ;//  "<>" or "\|" on RT 102-key kbd.
Global $VK_ICO_HELP      = 0xE3  ;//  Help key on ICO
Global $VK_ICO_00        = 0xE4  ;//  00 key on ICO
Global $VK_OEM_BACKTAB   = 0xF5
#ce

;~ Global $WM_KEYDOWN       = 0x0100 ;;declared in WindowConstants.au3
;~ Global $WM_KEYUP         = 0x0101 ;;declared in WindowConstants.au3


;~ _SendMinimizedMessage(WinGetHandle("Diablo II"),"test")

Func _SendMinimizedMessage($winhandle,$msgstring,$raw = 0)
	If $winhandle = "" Then
        ;; illegal number of parameters?
        MsgBox(32, "KCH: Problem", "SendMinimizedMessage() called with bad number of params?")
        Exit
    EndIf
	Local $i = 0
	while $i < StringLen($msgstring)
		$i = $i + 1
		Local $var = StringMid($msgstring,$i,1)
		if $raw = 1 Then
			_SendMinimizedVK($winhandle,StringMid($msgstring,$i,1))
		Else
			if $var = "{" Then
				Local $var2 = StringInStr(StringMid($msgstring,$i+1),"}",2)
				_SendMinimizedVK($winhandle,StringMid($msgstring,$i+1,$var2-1))
				$i = $i + $var2
			Else
				_SendMinimizedVK($winhandle,StringMid($msgstring,$i,1))
			EndIf
		EndIf
		Sleep(50)
	WEnd
	Return
EndFunc

Func _SendMinimizedVK($winhandle,$vkstring)
	Local $var = _GetHexByKey_Switch($vkstring)
	if Not ($var = -1) Then
		DllCall("user32.dll", "int", "SendMessage", _
		"hwnd", $winhandle, _
		"int", $WM_KEYDOWN, _
		"int", _GetHexByKey_Switch($vkstring), _
		"long", 0)
		DllCall("user32.dll", "int", "PostMessage", _ ;SendMessage only works ingame, not in lobby
		"hwnd", $winhandle, _
		"int", $WM_KEYUP, _
		"int", _GetHexByKey_Switch($vkstring), _
		"long", 0) 
;~ 		ConsoleWrite(1 & @CRLF) ;debug Success
		Return 1
	EndIf
;~ 	ConsoleWrite(0 & @CRLF) ;debug Failed
	Return 0
EndFunc

Func _GetHexByKey_Switch($sKey)
    Switch $sKey
		Case "LeftMouse"			
			Return 0x01	
		Case "RightMouse"			
			Return 0x02		
		Case "MiddleMouse"			
			Return 0x04		
		Case "X1Mouse"			
			Return 0x05		
		Case "X2Mouse"			
			Return 0x06		
		Case "BACKSPACE"			
			Return 0x08		
		Case "TAB"			
			Return 0x09		
		Case "CLEAR"			
			Return 0x0C		
		Case "ENTER"			
			Return 0x0D		
		Case "SHIFT"			
			Return 0x10		
		Case "CTRL"			
			Return 0x11		
		Case "ALT"			
			Return 0x12		
		Case "PAUSE"			
			Return 0x13		
		Case "CAPSLOCK"			
			Return 0x14		
		Case "ESC"			
			Return 0x1B		
		Case " "			
			Return 0x20	
		Case "SPACE"			
			Return 0x20		
		Case "PAGE UP"			
			Return 0x21		
		Case "PAGE DOWN"			
			Return 0x22		
		Case "END"			
			Return 0x23		
		Case "HOME"			
			Return 0x24		
		Case "LEFT"			
			Return 0x25		
		Case "UP"			
			Return 0x26		
		Case "RIGHT"			
			Return 0x27		
		Case "DOWN"			
			Return 0x28		
		Case "SELECT"			
			Return 0x29		
		Case "PRINT"			
			Return 0x2A		
		Case "EXECUTE"			
			Return 0x2B		
		Case "PRINT SCREEN"			
			Return 0x2C		
		Case "INS"			
			Return 0x2D		
		Case "DEL"			
			Return 0x2E		
		Case "0"			
			Return 0x30		
		Case "1"			
			Return 0x31		
		Case "2"			
			Return 0x32		
		Case "3"			
			Return 0x33		
		Case "4"			
			Return 0x34		
		Case "5"			
			Return 0x35		
		Case "6"			
			Return 0x36		
		Case "7"			
			Return 0x37		
		Case "8"			
			Return 0x38		
		Case "9"			
			Return 0x39		
		Case "A"			
			Return 0x41		
		Case "B"			
			Return 0x42		
		Case "C"			
			Return 0x43		
		Case "D"			
			Return 0x44		
		Case "E"			
			Return 0x45		
		Case "F"		
			Return 0x46		
		Case "G"			
			Return 0x47		
		Case "H"			
			Return 0x48		
		Case "I"			
			Return 0x49		
		Case "J"			
			Return 0x4A		
		Case "K"			
			Return 0x4B		
		Case "L"			
			Return 0x4C		
		Case "M"			
			Return 0x4D		
		Case "N"			
			Return 0x4E		
		Case "O"			
			Return 0x4F		
		Case "P"			
			Return 0x50		
		Case "Q"			
			Return 0x51		
		Case "R"			
			Return 0x52		
		Case "S"			
			Return 0x53		
		Case "T"			
			Return 0x54		
		Case "U"			
			Return 0x55		
		Case "V"			
			Return 0x56		
		Case "W"			
			Return 0x57		
		Case "X"			
			Return 0x58		
		Case "Y"			
			Return 0x59		
		Case "Z"			
			Return 0x5A		
		Case "LWin"			
			Return 0x5B		
		Case "RWin"			
			Return 0x5C		
		Case "NUMPAD0"			
			Return 0x60		
		Case "NUMPAD1"			
			Return 0x61		
		Case "NUMPAD2"			
			Return 0x62		
		Case "NUMPAD3"			
			Return 0x63		
		Case "NUMPAD4"			
			Return 0x64		
		Case "NUMPAD5"			
			Return 0x65		
		Case "NUMPAD6"			
			Return 0x66		
		Case "NUMPAD7"			
			Return 0x67		
		Case "NUMPAD8"			
			Return 0x68		
		Case "NUMPAD9"			
			Return 0x69		
		Case "Multiply"			
			Return 0x6A		
		Case "Add"			
			Return 0x6B		
		Case "Separator"			
			Return 0x6C		
		Case "Subtract"			
			Return 0x6D		
		Case "Decimal"			
			Return 0x6E		
		Case "Divide"			
			Return 0x6F		
		Case "F1"			
			Return 0x70		
		Case "F2"			
			Return 0x71		
		Case "F3"			
			Return 0x72		
		Case "F4"			
			Return 0x73		
		Case "F5"			
			Return 0x74		
		Case "F6"			
			Return 0x75		
		Case "F7"			
			Return 0x76		
		Case "F8"			
			Return 0x77		
		Case "F9"			
			Return 0x78		
		Case "F10"			
			Return 0x79		
		Case "F11"			
			Return 0x7A		
		Case "F12"			
			Return 0x7B		
		Case "F13"			
			Return 0x7C		
		Case "F16"			
			Return 0x7F		
		Case "F17"			
			Return 0x80	
		Case "F18"			
			Return 0x81
		Case "F19"			
			Return 0x82	
		Case "F20"			
			Return 0x83	
		Case "F21"			
			Return 0x84	
		Case "F22"			
			Return 0x85	
		Case "F23"			
			Return 0x86		
		Case "F24"			
			Return 0x87		
		Case "NUM LOCK"			
			Return 0x90	
		Case "SCROLL LOCK"			
			Return 0x91		
		Case "LSHIFT"			
			Return 0xA0		
		Case "RSHIFT"			
			Return 0xA1		
		Case "LCTRL"			
			Return 0xA2		
		Case "RCTRL"			
			Return 0xA3		
		Case "LMENU"			
			Return 0xA4		
		Case "RMENU"			
			Return 0xA5		
		Case "="
			Return 0x92
		Case ";"
			Return 0xBA
		Case ":"
			Return 0xBA
		Case "+"
			Return 0xBB
		Case ","
			Return 0xBC
		Case "-"
			Return 0xBD
		Case "."
			Return 0xBE
		Case "/"
			Return 0xBF
		Case "?"
			Return 0xBF
		Case "`"
			Return 0xC0
		Case "~"
			Return 0xC0
		Case "["
			Return 0xDB
		Case "{"
			Return 0xDB
		Case "\"
			Return 0xDC
		Case "|"
			Return 0xDC
		Case "]"
			Return 0xDD
		Case "}"
			Return 0xDD
		Case "'"
			Return 0xDE
		Case '"'
			Return 0xDE
		Case "<"
			Return 0xE2
		Case ">"
			Return 0xE2
    EndSwitch
    Return -1
EndFunc   ;==>_GetHexByKey_Switch

;===============================================================================
;
; Function Name:  _MouseClickMinimized()
; Version added:  0.1
; Description:    Sends a click to window, not entirely accurate, but works
;                 minimized.
; Parameter(s):   $Window     =  Title of the window to send click to
;                 $Button     =  "left" or "right" mouse button
;                 $X          =  X coordinate
;                 $Y          =  Y coordinate
;                 $Clicks     =  Number of clicks to send
; Remarks:        You MUST be in "MouseCoordMode" 0 (cpf: or 2???) to use this without bugs.
; Author(s):      Insolence <insolence_9@yahoo.com>
;
;===============================================================================
Func _MouseClickMinimized($Window, $Button = "left", $X = "", $Y = "", $Clicks = 1)
    Local $MK_LBUTTON = 0x0001
    Local $WM_LBUTTONDOWN = 0x0201
    Local $WM_LBUTTONUP = 0x0202
    Local $MK_RBUTTON = 0x0002
    Local $WM_RBUTTONDOWN = 0x0204
    Local $WM_RBUTTONUP = 0x0205
    Local $WM_MOUSEMOVE = 0x0200
    Local $i = 0
    Select
        Case $Button = "right"
            $Button = $MK_RBUTTON
            $ButtonDown = $WM_RBUTTONDOWN
            $ButtonUp = $WM_RBUTTONUP
        Case $Button = "left"
            $Button = $MK_LBUTTON
            $ButtonDown = $WM_LBUTTONDOWN
            $ButtonUp = $WM_LBUTTONUP
        Case Else  ;; CPF
            ;; illegal number of parameters?
            MsgBox(32, "KCH: Problem", "_MouseClickPlus() called with bad number of params?")
            Exit
    EndSelect
    ;; makes no sense to send click to minimized window with current mouse coordinates
    If $X = "" Or $Y = "" Then
        ;; illegal number of parameters?
        MsgBox(32, "KCH: Problem", "_MouseClickPlus() called with bad number of params?")
        Exit
    EndIf
    For $i = 1 To $Clicks
        DllCall("user32.dll", "int", "SendMessage", _
                "hwnd", WinGetHandle($Window), _
                "int", $WM_MOUSEMOVE, _
                "int", 0, _
                "long", _MakeLong($X, $Y))
        DllCall("user32.dll", "int", "SendMessage", _
                "hwnd", WinGetHandle($Window), _
                "int", $ButtonDown, _
                "int", $Button, _
                "long", _MakeLong($X, $Y)) 
		Sleep(10)
        DllCall("user32.dll", "int", "SendMessage", _
                "hwnd", WinGetHandle($Window), _
                "int", $ButtonUp, _
                "int", $Button, _
                "long", _MakeLong($X, $Y)) 
    Next
EndFunc   ;==>_MouseClickMinimized

;===============================================================================
;
; Function Name:  _MouseMoveMinimized()
; Version added:  0.1
; Description:    Sends a move message to window, works minimized.
; Parameter(s):   $Window     =  Title of the window to send click to
;                 $X          =  X coordinate
;                 $Y          =  Y coordinate
; Remarks:        You MUST be in "MouseCoordMode" 0 (cpf: or 2???) to use this without bugs.
; Author(s):      Cris Fuhrman (based on code by Insolence <insolence_9@yahoo.com>)
;
;===============================================================================
Func _MouseMoveMinimized($Window, $X = "", $Y = "")
    Local $WM_MOUSEMOVE = 0x0200
    Local $i = 0
    
    If $X = "" Or $Y = "" Then
        MsgBox(32, "KCH: Problem", "_MouseMovePlus() called with bad number of params?")
        Exit
    EndIf
    
    DllCall("user32.dll", "int", "SendMessage", _
            "hwnd", WinGetHandle($Window), _
            "int", $WM_MOUSEMOVE, _
            "int", 0, _
            "long", _MakeLong($X, $Y)) 
EndFunc   ;==>_MouseMoveMinimized

Func _MakeLong($LoWord, $HiWord)
    Return BitOR($HiWord * 0x10000, BitAND($LoWord, 0xFFFF))
EndFunc   ;==>_MakeLong